# Session usage

To store items in the session call the put method on the Session class.

```php
Pimf\Session::put('name', 'Rob');
```
    
The first parameter is the key to the session item. You will use this key to retrieve the item from the session. The second parameter is the value of the item.

You can use the get method on the Session class to retrieve any item in the session, including flash data. Just pass the key of the item you wish to retrieve:

```php
$name = Pimf\Session::get('name');
```

By default, NULL will be returned if the session item does not exist. However, you may pass a default value as a second parameter to the get method:

```php
$name = Pimf\Session::get('name', 'Rob');
$name = Pimf\Session::get('name', function() {return 'Rob';});
```

PIMF even provides a simple way to determine if a session item exists using the has method:

```php
if (Session::has('name')) {
     $name = Pimf\Session::get('name');
}
```

To remove an item from the session use the forget method on the Session class.

```php
Pimf\Session::forget('name');
```

You can even remove all of the items from the session using the flush method.

```php
Pimf\Session::flush();
```

The flash method stores an item in the session that will expire after the next request. It`s useful for storing temporary data like status or error messages:

```php
Pimf\Session::flash('status', 'Welcome Back!');
```

Flash items that are expiring in subsequent requests can be retained for another request by using one of the reflash or keep methods:

Retain all items for another request:

```php
Pimf\Session::reflash();
```

Retain an individual item for another request:

```php
Pimf\Session::keep('status');
```

Retain several items for another request:

```php
Pimf\Session::keep(array('status', 'other_item'));
```

Sometimes you may want to "regenerate" the session ID. This simply means that a new, random session ID will be assigned to the session. Here's how to do it:

```php
Pimf\Session::regenerate();
```
